<!DOCTYPE html>
<html lang="pl" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars(APP_NAME); ?> - Odczytaj wiadomość</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/4.1.1/crypto-js.min.js"></script>
    <link rel="stylesheet" href="<?php echo parse_url(APP_URL)['path']; ?>/public/css/app.css">
    <meta name="robots" content="noindex, nofollow">
</head>
<body class="min-h-screen bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900 flex items-center justify-center p-4">
    <div class="max-w-4xl w-full">
        <div class="text-center mb-8 animate-fade-in">
            <div class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-blue-500 to-purple-600 rounded-2xl mb-4 shadow-lg">
                <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                </svg>
            </div>
            <h1 class="text-4xl font-bold text-white mb-2"><?php echo htmlspecialchars(APP_NAME); ?></h1>
            <p class="text-gray-400">Tajna wiadomość</p>
        </div>

        <div id="loadingState" class="bg-gray-800/50 backdrop-blur-sm rounded-2xl shadow-2xl p-8 card-shadow">
            <div class="flex flex-col items-center justify-center py-8">
                <div class="spinner mb-4"></div>
                <p class="text-gray-300 text-lg font-medium">Ładowanie wiadomości...</p>
                <p class="text-gray-500 text-sm mt-2">Deszyfrowanie treści</p>
            </div>
        </div>

        <div id="messageContainer" class="hidden bg-gray-800/50 backdrop-blur-sm rounded-2xl shadow-2xl p-8 card-shadow message-reveal">
            <div class="flex items-center justify-between mb-6">
                <h2 class="text-xl font-semibold text-white flex items-center">
                    <svg class="w-5 h-5 mr-2 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 11V7a4 4 0 118 0m-4 8v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2z"/>
                    </svg>
                    Wiadomość odszyfrowana
                </h2>
                <span id="testModeBadge" class="hidden px-3 py-1 bg-yellow-900/50 text-yellow-400 text-xs font-medium rounded-full">
                    TRYB TESTOWY
                </span>
            </div>

            <div id="messageContent" class="bg-gray-900/50 rounded-lg p-6 mb-6">
                <div id="decryptedMessage" class="text-gray-200 whitespace-pre-wrap break-words"></div>
            </div>

            <div id="messageWarning" class="hidden">
                <div class="bg-red-900/20 border border-red-500/30 rounded-lg p-4 mb-4">
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-red-400 mr-3 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                        </svg>
                        <div class="flex-1">
                            <p class="text-red-400 font-medium">Ta wiadomość zniknie za <span id="countdown" class="font-bold"><?php echo MESSAGE_BURN_DELAY; ?></span> sekund!</p>
                            <p class="text-red-300 text-sm mt-1">Po tym czasie nie będzie można jej już odczytać.</p>
                            
                            <div class="mt-3">
                                <div class="w-full bg-gray-700 rounded-full h-2">
                                    <div id="progressBar" class="bg-red-500 h-2 rounded-full" style="width: 100%"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="testModeInfo" class="hidden">
                <div class="bg-yellow-900/20 border border-yellow-500/30 rounded-lg p-4 mb-4">
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-yellow-400 mr-3 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <div class="flex-1">
                            <p class="text-yellow-400 font-medium">Tryb testowy aktywny</p>
                            <p class="text-yellow-300 text-sm mt-1">Ta wiadomość nie zostanie usunięta po odczycie. Możesz ją odświeżyć, aby zobaczyć ponownie.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex gap-4">
                <button 
                    onclick="copyMessage()" 
                    class="flex-1 btn-secondary flex items-center justify-center">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                    </svg>
                    Kopiuj treść
                </button>
                <a href="<?php echo parse_url(APP_URL)['path']; ?>/" class="flex-1 btn-primary text-center">
                    Utwórz nową wiadomość
                </a>
            </div>
        </div>

        <div id="errorContainer" class="hidden bg-gray-800/50 backdrop-blur-sm rounded-2xl shadow-2xl p-8 card-shadow">
            <div class="text-center py-8">
                <div class="inline-flex items-center justify-center w-16 h-16 bg-red-900/50 rounded-full mb-4">
                    <svg class="w-8 h-8 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                    </svg>
                </div>
                <h2 class="text-xl font-semibold text-white mb-2">Nie można odczytać wiadomości</h2>
                <p id="errorMessage" class="text-gray-400 mb-6">Wiadomość nie istnieje, została już odczytana lub wygasła.</p>
                <a href="<?php echo parse_url(APP_URL)['path']; ?>/" class="btn-primary inline-flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                    </svg>
                    Utwórz nową wiadomość
                </a>
            </div>
        </div>

        <div id="destroyedContainer" class="hidden bg-gray-800/50 backdrop-blur-sm rounded-2xl shadow-2xl p-8 card-shadow">
            <div class="text-center py-8">
                <div class="inline-flex items-center justify-center w-16 h-16 bg-green-900/50 rounded-full mb-4">
                    <svg class="w-8 h-8 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 18.657A8 8 0 016.343 7.343S7 9 9 10c0-2 .5-5 2.986-7C14 5 16.09 5.777 17.656 7.343A7.975 7.975 0 0120 13a7.975 7.975 0 01-2.343 5.657z"/>
                    </svg>
                </div>
                <h2 class="text-xl font-semibold text-white mb-2">Wiadomość zniszczona</h2>
                <p class="text-gray-400 mb-6">Wiadomość została bezpiecznie usunięta i nie można jej już odczytać.</p>
                <a href="<?php echo parse_url(APP_URL)['path']; ?>/" class="btn-primary inline-flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                    </svg>
                    Utwórz nową wiadomość
                </a>
            </div>
        </div>
    </div>

    <script>
        const messageId = '<?php echo $messageId; ?>';
        const isTestMode = <?php echo $isTestMode ? 'true' : 'false'; ?>;
        
        window.burnDelay = <?php echo MESSAGE_BURN_DELAY; ?>;
        
        window.appConfig = {
            burnDelay: <?php echo MESSAGE_BURN_DELAY; ?>,
            maxSize: <?php echo MESSAGE_MAX_SIZE; ?>,
            appUrl: '<?php echo APP_URL; ?>'
        };
    </script>
    
    <div class="text-center mt-8">
        <p class="text-gray-500 text-sm">Stworzone z ❤️ przez <a href="https://boredmarcin.com" target="_blank" class="text-blue-400 hover:text-blue-300 transition-colors">boredmarcin.com</a></p>
    </div>
    
    <script src="<?php echo parse_url(APP_URL)['path']; ?>/public/js/message.js"></script>
</body>
</html>