<!DOCTYPE html>
<html lang="pl" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars(APP_NAME); ?> - Jednorazowe wiadomości</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo parse_url(APP_URL)['path']; ?>/public/css/app.css">
    <meta name="description" content="Wysyłaj bezpieczne, jednorazowe wiadomości, które znikają po przeczytaniu">
</head>
<body class="min-h-screen bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900 flex items-center justify-center p-4">
    <div class="max-w-4xl w-full">
        <div class="text-center mb-8 animate-fade-in">
            <div class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-blue-500 to-purple-600 rounded-2xl mb-4 shadow-lg">
                <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                </svg>
            </div>
            <h1 class="text-4xl font-bold text-white mb-2"><?php echo htmlspecialchars(APP_NAME); ?></h1>
            <p class="text-gray-400">Jednorazowe wiadomości, które znikają po przeczytaniu</p>
        </div>

        <div class="bg-gray-800/50 backdrop-blur-sm rounded-2xl shadow-2xl p-8 card-shadow">
            <form id="createForm" class="space-y-6">
                <input type="hidden" name="csrf_token" id="csrf_token" value="<?php echo $_SESSION['csrf_token'] ?? ''; ?>">
                <div>
                    <label for="message" class="block text-sm font-medium text-gray-300 mb-2">
                        Twoja tajna wiadomość
                    </label>
                    <textarea 
                        id="message" 
                        name="message" 
                        rows="6" 
                        class="input-field resize-none"
                        placeholder="Wpisz swoją wiadomość tutaj..."
                        maxlength="<?php echo MESSAGE_MAX_SIZE; ?>"
                        required></textarea>
                    <div class="mt-2 flex justify-between text-xs text-gray-500">
                        <span>Wiadomość zostanie zaszyfrowana end-to-end</span>
                        <span id="charCount">0 / <?php echo MESSAGE_MAX_SIZE; ?></span>
                    </div>
                </div>

                <div class="space-y-4">
                    <div>
                        <label for="customExpiry" class="block text-sm font-medium text-gray-300 mb-2">
                            Czas wygaśnięcia
                        </label>
                        <select id="customExpiry" name="customExpiry" class="w-full p-3 bg-gray-700 text-white rounded-lg border border-gray-600 focus:border-blue-500 focus:outline-none focus:ring-1 focus:ring-blue-500">
                            <option value="3600">1 godzina</option>
                            <option value="21600">6 godzin</option>
                            <option value="86400" selected>24 godziny (domyślnie)</option>
                            <option value="259200">3 dni</option>
                            <option value="604800">7 dni</option>
                        </select>
                        <p class="text-xs text-gray-500 mt-1">Po tym czasie wiadomość zostanie automatycznie usunięta</p>
                    </div>
                    
                    <?php if (defined('ENABLE_TEST_MODE') && ENABLE_TEST_MODE): ?>
                    <label class="flex items-center cursor-pointer group">
                        <input 
                            type="checkbox" 
                            id="testMode" 
                            name="testMode"
                            class="w-4 h-4 text-blue-600 bg-gray-700 border-gray-600 rounded focus:ring-blue-500 focus:ring-2">
                        <span class="ml-3 text-gray-300 group-hover:text-white transition-colors">
                            <span class="font-medium">Tryb testowy</span>
                            <span class="text-xs text-gray-500 block">Wiadomość nie zniknie po odczycie</span>
                        </span>
                    </label>
                    <?php endif; ?>
                </div>

                <button type="submit" class="btn-primary flex items-center justify-center" id="submitBtn">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                    Wygeneruj bezpieczny link
                </button>
            </form>

            <div id="loadingState" class="hidden">
                <div class="flex flex-col items-center justify-center py-8 animate-fade-in">
                    <div class="relative">
                        <div class="spinner mb-4"></div>
                        <div class="absolute inset-0 flex items-center justify-center">
                            <div class="w-6 h-6 bg-blue-500 rounded-full animate-ping opacity-20"></div>
                        </div>
                    </div>
                    <p class="text-gray-400 animate-pulse">Szyfrowanie wiadomości...</p>
                    <div class="mt-2 text-xs text-gray-500">
                        <span class="inline-block animate-bounce delay-0">🔒</span>
                        <span class="inline-block animate-bounce delay-100">⚡</span>
                        <span class="inline-block animate-bounce delay-200">🛡️</span>
                    </div>
                </div>
            </div>


            <div id="errorState" class="hidden">
                <div class="alert-error">
                    <div class="flex items-start">
                        <svg class="w-6 h-6 text-red-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <div>
                            <h3 class="text-red-400 font-semibold mb-1">Wystąpił błąd</h3>
                            <p id="errorMessage" class="text-red-200 text-sm"></p>
                            <button 
                                onclick="resetForm()" 
                                class="mt-3 btn-text">
                                Spróbuj ponownie
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-3 gap-4 mt-8">
            <div class="text-center">
                <div class="inline-flex items-center justify-center w-12 h-12 bg-gray-800 rounded-lg mb-2">
                    <svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                    </svg>
                </div>
                <h3 class="text-white text-sm font-medium">Szyfrowane</h3>
                <p class="text-gray-500 text-xs mt-1">AES-256-CBC</p>
            </div>
            <div class="text-center">
                <div class="inline-flex items-center justify-center w-12 h-12 bg-gray-800 rounded-lg mb-2">
                    <svg class="w-6 h-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 18.657A8 8 0 016.343 7.343S7 9 9 10c0-2 .5-5 2.986-7C14 5 16.09 5.777 17.656 7.343A7.975 7.975 0 0120 13a7.975 7.975 0 01-2.343 5.657z"/>
                    </svg>
                </div>
                <h3 class="text-white text-sm font-medium">Jednorazowe</h3>
                <p class="text-gray-500 text-xs mt-1">Znika po odczycie</p>
            </div>
            <div class="text-center">
                <div class="inline-flex items-center justify-center w-12 h-12 bg-gray-800 rounded-lg mb-2">
                    <svg class="w-6 h-6 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <h3 class="text-white text-sm font-medium">Prywatne</h3>
                <p class="text-gray-500 text-xs mt-1">Bez logowania</p>
            </div>
        </div>
    </div>

    <div id="successState" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center p-4 z-50" onclick="closeSuccessModal()">
        <div class="bg-gray-800 rounded-2xl shadow-2xl max-w-4xl w-full max-h-[90vh] overflow-y-auto" onclick="event.stopPropagation()">
            <div class="bg-green-900/20 border-b border-green-500/30 p-6">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="inline-flex items-center justify-center w-12 h-12 bg-green-600 rounded-full mr-4">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div>
                            <h2 class="text-2xl font-bold text-green-400">Link został wygenerowany!</h2>
                            <p class="text-green-300">Wiadomość została zaszyfrowana i jest gotowa do wysłania</p>
                        </div>
                    </div>
                    <button onclick="closeSuccessModal()" class="text-gray-400 hover:text-white transition-colors">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
            </div>
            
            <div class="p-6">
                <div class="bg-yellow-900/20 border border-yellow-500/30 rounded-lg p-4 mb-6">
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-yellow-400 mr-3 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                        </svg>
                        <div>
                            <h3 class="text-yellow-400 font-medium mb-1">Ważne!</h3>
                            <p class="text-yellow-300 text-sm">Skopiuj link teraz - po zamknięciu tego okna nie będzie można go odzyskać. Wiadomość można odczytać tylko raz.</p>
                        </div>
                    </div>
                </div>
                
                <div class="mb-6">
                    <label class="block text-gray-300 font-medium mb-3">Twój bezpieczny link:</label>
                    <div class="bg-gray-900/50 rounded-lg p-4 border border-gray-600">
                        <div class="flex items-center gap-3">
                            <input 
                                type="text" 
                                id="generatedLink" 
                                readonly 
                                class="flex-1 bg-transparent text-blue-400 font-mono text-sm pr-2 focus:outline-none cursor-pointer break-all"
                                onclick="this.select()">
                            <button 
                                id="copyBtn" 
                                class="btn-primary flex items-center whitespace-nowrap"
                                onclick="copyToClipboard()">
                                <svg id="copyIcon" class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                                </svg>
                                <svg id="checkIcon" class="w-4 h-4 mr-2 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                </svg>
                                <span id="copyText">Kopiuj link</span>
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                    <div class="bg-gray-900/30 rounded-lg p-4">
                        <div class="flex items-center mb-2">
                            <svg class="w-5 h-5 text-blue-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <h4 class="text-white font-medium">Wygaśnięcie</h4>
                        </div>
                        <p id="expiryInfo" class="text-gray-400 text-sm"></p>
                    </div>
                    
                    <div class="bg-gray-900/30 rounded-lg p-4">
                        <div class="flex items-center mb-2">
                            <svg class="w-5 h-5 text-purple-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.031 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                            </svg>
                            <h4 class="text-white font-medium">Bezpieczeństwo</h4>
                        </div>
                        <p class="text-gray-400 text-sm">Zaszyfrowane AES-256-CBC</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="text-center mt-8">
        <p class="text-gray-500 text-sm">Stworzone z ❤️ przez <a href="https://boredmarcin.com" target="_blank" class="text-blue-400 hover:text-blue-300 transition-colors">boredmarcin.com</a></p>
    </div>

    <script src="<?php echo parse_url(APP_URL)['path']; ?>/public/js/app.js"></script>
</body>
</html>