<!DOCTYPE html>
<html lang="pl" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Nie znaleziono strony</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo parse_url(APP_URL)['path']; ?>/public/css/app.css">
</head>
<body class="min-h-screen bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900 flex items-center justify-center p-4">
    <div class="max-w-2xl w-full text-center">
        <div class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-red-500 to-orange-600 rounded-2xl mb-6 shadow-lg">
            <span class="text-3xl font-bold text-white">404</span>
        </div>
        <h1 class="text-3xl font-bold text-white mb-3">Strona nie znaleziona</h1>
        <p class="text-gray-400 mb-8">Wiadomość została już odczytana, wygasła lub nie istnieje.</p>
        <a href="<?php echo rtrim(parse_url(APP_URL)['path'] ?? '', '/') ?: '/'; ?>/" class="btn-primary inline-flex items-center justify-center">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
            </svg>
            Wróć do strony głównej
        </a>
    </div>
</body>
</html>